/*
 * Decompiled with CFR 0.152.
 */
package net.angelluislopez.crossownership;

import net.angelluislopez.crossownership.TotalSimu;
import org.apache.commons.math3.analysis.UnivariateFunction;
import org.apache.commons.math3.optim.MaxEval;
import org.apache.commons.math3.optim.nonlinear.scalar.GoalType;
import org.apache.commons.math3.optim.univariate.BrentOptimizer;
import org.apache.commons.math3.optim.univariate.MultiStartUnivariateOptimizer;
import org.apache.commons.math3.optim.univariate.SearchInterval;
import org.apache.commons.math3.optim.univariate.UnivariateObjectiveFunction;
import org.apache.commons.math3.optim.univariate.UnivariateOptimizer;
import org.apache.commons.math3.random.JDKRandomGenerator;

class CE2S
extends TotalSimu {
    JDKRandomGenerator g;
    double a;
    double C;
    double epsilon;
    double alpha;
    private double Fbeta = 0.5;

    CE2S(double N, double Epsilon, double Alpha) {
        super(N);
        this.epsilon = Epsilon;
        this.alpha = Alpha;
        this.sigma = 1.0;
        this.kappa = 1.0;
        this.a = 0.0;
        this.C = 0.0;
        this.g = new JDKRandomGenerator();
        this.g.setSeed(44428400075L);
    }

    @Override
    void setFbeta(double aFbeta) {
        this.Fbeta = aFbeta;
    }

    @Override
    double getFbeta() {
        return this.Fbeta;
    }

    public void setSigma(double aSigma) {
        this.sigma = aSigma;
    }

    public void setKappa(double aKappa) {
        this.kappa = aKappa;
    }

    public void setEpsilon(double Epsilon) {
        this.epsilon = Epsilon;
    }

    @Override
    public double getEpsilon() {
        return this.epsilon;
    }

    public void setAlpha(double Alpha) {
        this.alpha = Alpha;
    }

    @Override
    public double getAlpha() {
        return this.alpha;
    }

    double getA() {
        return 0.0;
    }

    double getC() {
        return 0.0;
    }

    @Override
    public double[] getLTSbeta() {
        double[] LTSbeta = new double[nsteps + 1];
        twFunctionSolver ws = new twFunctionSolver();
        for (int i = 0; i <= nsteps; ++i) {
            ws.beta = vBetas[i];
            ws.compute();
            LTSbeta[i] = ws.optimal;
        }
        return LTSbeta;
    }

    @Override
    public double[] getMhhiTSbeta() {
        double[] lambdaTSbeta = new double[nsteps + 1];
        lambdaTSbeta = this.getLTSbeta();
        double[] mhhi = new double[nsteps + 1];
        for (int i = 0; i <= nsteps; ++i) {
            mhhi[i] = (1.0 + lambdaTSbeta[i] * (this.getN() - 1.0)) / this.getN();
        }
        return mhhi;
    }

    @Override
    public double[] getLCSbeta() {
        double[] LCSbeta = new double[nsteps + 1];
        csFunctionSolver cs = new csFunctionSolver();
        for (int i = 0; i <= nsteps; ++i) {
            cs.beta = vBetas[i];
            cs.compute();
            LCSbeta[i] = cs.optimal;
        }
        return LCSbeta;
    }

    @Override
    public double[] getMhhiCSbeta() {
        double[] mhhi = new double[nsteps + 1];
        double[] lambdacsbeta = new double[nsteps + 1];
        lambdacsbeta = this.getLCSbeta();
        for (int i = 0; i <= nsteps; ++i) {
            mhhi[i] = (1.0 + lambdacsbeta[i] * (this.getN() - 1.0)) / this.getN();
        }
        return mhhi;
    }

    @Override
    public double getBetaupperbar() {
        boolean flag = false;
        double[] lambdafctbeta = new double[nsteps + 1];
        double value = -1.0;
        lambdafctbeta = this.getLTSbeta();
        for (int i = 0; i <= nsteps; ++i) {
            if (!(lambdafctbeta[i] > 1.0E-6)) continue;
            flag = true;
            value = vBetas[i];
            break;
        }
        if (flag) {
            return value;
        }
        return -1.0;
    }

    @Override
    public double getBetaprime() {
        boolean flag = false;
        double[] lambdafctbeta = new double[nsteps + 1];
        double value = -1.0;
        lambdafctbeta = this.getLCSbeta();
        for (int i = 0; i <= nsteps; ++i) {
            if (!(lambdafctbeta[i] > 1.0E-6)) continue;
            flag = true;
            value = vBetas[i];
            break;
        }
        if (flag) {
            return value;
        }
        return -1.0;
    }

    @Override
    double[] getWlambda() {
        double[] Wlambda = new double[nsteps + 1];
        for (int i = 0; i <= nsteps; ++i) {
            double Lambda = 1.0 + vLambdas[i] * (this.getN() - 1.0);
            double tau = 1.0 + vLambdas[i] * (this.getN() - 1.0) * this.Fbeta;
            double B = 1.0 + this.Fbeta * (this.getN() - 1.0);
            double delta = -1.0 - this.epsilon;
            double BIC = (this.getN() * (1.0 + vLambdas[i]) + Lambda * delta) / (2.0 * this.getN() + Lambda * delta);
            double omega = Lambda / this.getN() * (2.0 * this.getN() + Lambda * delta) / (this.getN() + Lambda * (delta + 1.0));
            double s = omega * (BIC - this.Fbeta);
            double q = 1.0 / this.alpha / this.kappa / ((this.getN() - 1.0) * s + tau) * Math.pow(this.sigma * Math.pow(((this.getN() - 1.0) * s + tau) * this.alpha / this.getN(), this.epsilon) * Math.pow(this.kappa, this.epsilon - 1.0) * (1.0 - this.epsilon * Lambda / this.getN()), (1.0 + this.alpha) / (this.epsilon - this.alpha * (1.0 - this.epsilon)));
            double Q = this.getN() * q;
            double x = 1.0 / B * Math.pow(this.sigma * Math.pow(((this.getN() - 1.0) * s + tau) * this.alpha / this.getN(), this.epsilon) * Math.pow(this.kappa, this.epsilon - 1.0) * (1.0 - this.epsilon * Lambda / this.getN()), 1.0 / (this.epsilon - this.alpha * (1.0 - this.epsilon)));
            double pd = -this.epsilon + 1.0;
            double cs = this.sigma * Math.pow(Q, pd) / pd;
            double c = this.kappa * Math.pow(B * x, -this.alpha);
            Wlambda[i] = cs - this.getN() * c * q - this.getN() * x;
        }
        return Wlambda;
    }

    @Override
    double[] getCSlambda() {
        double[] CSlambda = new double[nsteps + 1];
        for (int i = 0; i <= nsteps; ++i) {
            double ncs;
            double Lambda = 1.0 + vLambdas[i] * (this.getN() - 1.0);
            double tau = 1.0 + vLambdas[i] * (this.getN() - 1.0) * this.Fbeta;
            double B = 1.0 + this.Fbeta * (this.getN() - 1.0);
            double delta = -1.0 - this.epsilon;
            double BIC = (this.getN() * (1.0 + vLambdas[i]) + Lambda * delta) / (2.0 * this.getN() + Lambda * delta);
            double omega = Lambda / this.getN() * (2.0 * this.getN() + Lambda * delta) / (this.getN() + Lambda * (delta + 1.0));
            double s = omega * (BIC - this.Fbeta);
            double q = 1.0 / this.alpha / this.kappa / ((this.getN() - 1.0) * s + tau) * Math.pow(this.sigma * Math.pow(((this.getN() - 1.0) * s + tau) * this.alpha / this.getN(), this.epsilon) * Math.pow(this.kappa, this.epsilon - 1.0) * (1.0 - this.epsilon * Lambda / this.getN()), (1.0 + this.alpha) / (this.epsilon - this.alpha * (1.0 - this.epsilon)));
            double Q = this.getN() * q;
            double pd = -this.epsilon + 1.0;
            CSlambda[i] = ncs = this.sigma * Math.pow(Q, pd) / pd - this.sigma * Math.pow(Q, -this.epsilon) * Q;
        }
        return CSlambda;
    }

    @Override
    double[] getEqlambda() {
        double[] Eqlambda = new double[nsteps + 1];
        for (int i = 0; i <= nsteps; ++i) {
            double q;
            double Lambda = 1.0 + vLambdas[i] * (this.getN() - 1.0);
            double tau = 1.0 + vLambdas[i] * (this.getN() - 1.0) * this.Fbeta;
            double B = 1.0 + this.Fbeta * (this.getN() - 1.0);
            double delta = -1.0 - this.epsilon;
            double BIC = (this.getN() * (1.0 + vLambdas[i]) + Lambda * delta) / (2.0 * this.getN() + Lambda * delta);
            double omega = Lambda / this.getN() * (2.0 * this.getN() + Lambda * delta) / (this.getN() + Lambda * (delta + 1.0));
            double s = omega * (BIC - this.Fbeta);
            Eqlambda[i] = q = 1.0 / this.alpha / this.kappa / ((this.getN() - 1.0) * s + tau) * Math.pow(this.sigma * Math.pow(((this.getN() - 1.0) * s + tau) * this.alpha / this.getN(), this.epsilon) * Math.pow(this.kappa, this.epsilon - 1.0) * (1.0 - this.epsilon * Lambda / this.getN()), (1.0 + this.alpha) / (this.epsilon - this.alpha * (1.0 - this.epsilon)));
        }
        return Eqlambda;
    }

    @Override
    double[] getExlambda() {
        double[] Exlambda = new double[nsteps + 1];
        for (int i = 0; i <= nsteps; ++i) {
            double x;
            double Lambda = 1.0 + vLambdas[i] * (this.getN() - 1.0);
            double tau = 1.0 + vLambdas[i] * (this.getN() - 1.0) * this.Fbeta;
            double B = 1.0 + this.Fbeta * (this.getN() - 1.0);
            double delta = -1.0 - this.epsilon;
            double BIC = (this.getN() * (1.0 + vLambdas[i]) + Lambda * delta) / (2.0 * this.getN() + Lambda * delta);
            double omega = Lambda / this.getN() * (2.0 * this.getN() + Lambda * delta) / (this.getN() + Lambda * (delta + 1.0));
            double s = omega * (BIC - this.Fbeta);
            Exlambda[i] = x = 1.0 / B * Math.pow(this.sigma * Math.pow(((this.getN() - 1.0) * s + tau) * this.alpha / this.getN(), this.epsilon) * Math.pow(this.kappa, this.epsilon - 1.0) * (1.0 - this.epsilon * Lambda / this.getN()), 1.0 / (this.epsilon - this.alpha * (1.0 - this.epsilon)));
        }
        return Exlambda;
    }

    @Override
    double[] getEplambda() {
        double[] price = new double[nsteps + 1];
        double[] eqoutput = new double[nsteps + 1];
        eqoutput = this.getEqlambda();
        for (int i = 0; i <= nsteps; ++i) {
            double Q = this.getN() * eqoutput[i];
            price[i] = this.sigma * Math.pow(Q, -this.epsilon);
        }
        return price;
    }

    @Override
    double[] getEcostlambda() {
        double[] cost = new double[nsteps + 1];
        double[] eqx = new double[nsteps + 1];
        eqx = this.getExlambda();
        for (int i = 0; i <= nsteps; ++i) {
            double Lambda = 1.0 + vLambdas[i] * (this.getN() - 1.0);
            double tau = 1.0 + vLambdas[i] * (this.getN() - 1.0) * this.Fbeta;
            double B = 1.0 + this.Fbeta * (this.getN() - 1.0);
            double delta = -1.0 - this.epsilon;
            double BIC = (this.getN() * (1.0 + vLambdas[i]) + Lambda * delta) / (2.0 * this.getN() + Lambda * delta);
            double omega = Lambda / this.getN() * (2.0 * this.getN() + Lambda * delta) / (this.getN() + Lambda * (delta + 1.0));
            double s = omega * (BIC - this.Fbeta);
            double x = 1.0 / B * Math.pow(this.sigma * Math.pow(((this.getN() - 1.0) * s + tau) * this.alpha / this.getN(), this.epsilon) * Math.pow(this.kappa, this.epsilon - 1.0) * (1.0 - this.epsilon * Lambda / this.getN()), 1.0 / (this.epsilon - this.alpha * (1.0 - this.epsilon)));
            cost[i] = this.kappa * Math.pow(B * x, -this.alpha);
        }
        return cost;
    }

    @Override
    double[] getEprofitlambda() {
        double[] eqprice = new double[nsteps + 1];
        double[] eqoutput = new double[nsteps + 1];
        double[] eqx = new double[nsteps + 1];
        double[] ecost = new double[nsteps + 1];
        double[] profit = new double[nsteps + 1];
        eqoutput = this.getEqlambda();
        eqprice = this.getEplambda();
        eqx = this.getExlambda();
        ecost = this.getEcostlambda();
        for (int i = 0; i <= nsteps; ++i) {
            profit[i] = eqprice[i] * eqoutput[i] - ecost[i] * eqoutput[i] - eqx[i];
        }
        return profit;
    }

    class csFunction
    implements UnivariateFunction {
        double beta;

        csFunction(double Beta2) {
            this.beta = Beta2;
        }

        @Override
        public double value(double lambda) {
            double Lambda = 1.0 + lambda * (CE2S.this.getN() - 1.0);
            double tau = 1.0 + lambda * (CE2S.this.getN() - 1.0) * this.beta;
            double B = 1.0 + this.beta * (CE2S.this.getN() - 1.0);
            double delta = -1.0 - CE2S.this.epsilon;
            double BIC = (CE2S.this.getN() * (1.0 + lambda) + Lambda * delta) / (2.0 * CE2S.this.getN() + Lambda * delta);
            double omega = Lambda / CE2S.this.getN() * (2.0 * CE2S.this.getN() + Lambda * delta) / (CE2S.this.getN() + Lambda * (delta + 1.0));
            double s = omega * (BIC - this.beta);
            double q = 1.0 / CE2S.this.alpha / CE2S.this.kappa / ((CE2S.this.getN() - 1.0) * s + tau) * Math.pow(CE2S.this.sigma * Math.pow(((CE2S.this.getN() - 1.0) * s + tau) * CE2S.this.alpha / CE2S.this.getN(), CE2S.this.epsilon) * Math.pow(CE2S.this.kappa, CE2S.this.epsilon - 1.0) * (1.0 - CE2S.this.epsilon * Lambda / CE2S.this.getN()), (1.0 + CE2S.this.alpha) / (CE2S.this.epsilon - CE2S.this.alpha * (1.0 - CE2S.this.epsilon)));
            double Q = CE2S.this.getN() * q;
            double f = CE2S.this.sigma * Math.pow(Q, -CE2S.this.epsilon);
            double pd = -CE2S.this.epsilon + 1.0;
            double ncs = CE2S.this.sigma * Math.pow(Q, pd) / pd - f * Q;
            return ncs;
        }
    }

    class csFunctionSolver {
        double beta;
        double optimal;
        UnivariateOptimizer underlying = new BrentOptimizer(1.11E-14, 1.11E-15);
        MultiStartUnivariateOptimizer optimizer;

        csFunctionSolver() {
            this.optimizer = new MultiStartUnivariateOptimizer(this.underlying, 5, CE2S.this.g);
        }

        public void compute() {
            this.optimal = this.optimizer.optimize(new MaxEval(10000), new UnivariateObjectiveFunction(new csFunction(this.beta)), GoalType.MAXIMIZE, new SearchInterval(0.0, 1.0)).getPoint();
        }
    }

    class twFunction
    implements UnivariateFunction {
        double beta;

        twFunction(double Beta2) {
            this.beta = Beta2;
        }

        @Override
        public double value(double lambda) {
            double Lambda = 1.0 + lambda * (CE2S.this.getN() - 1.0);
            double tau = 1.0 + lambda * (CE2S.this.getN() - 1.0) * this.beta;
            double B = 1.0 + this.beta * (CE2S.this.getN() - 1.0);
            double delta = -1.0 - CE2S.this.epsilon;
            double BIC = (CE2S.this.getN() * (1.0 + lambda) + Lambda * delta) / (2.0 * CE2S.this.getN() + Lambda * delta);
            double omega = Lambda / CE2S.this.getN() * (2.0 * CE2S.this.getN() + Lambda * delta) / (CE2S.this.getN() + Lambda * (delta + 1.0));
            double s = omega * (BIC - this.beta);
            double q = 1.0 / CE2S.this.alpha / CE2S.this.kappa / ((CE2S.this.getN() - 1.0) * s + tau) * Math.pow(CE2S.this.sigma * Math.pow(((CE2S.this.getN() - 1.0) * s + tau) * CE2S.this.alpha / CE2S.this.getN(), CE2S.this.epsilon) * Math.pow(CE2S.this.kappa, CE2S.this.epsilon - 1.0) * (1.0 - CE2S.this.epsilon * Lambda / CE2S.this.getN()), (1.0 + CE2S.this.alpha) / (CE2S.this.epsilon - CE2S.this.alpha * (1.0 - CE2S.this.epsilon)));
            double Q = CE2S.this.getN() * q;
            double x = 1.0 / B * Math.pow(CE2S.this.sigma * Math.pow(((CE2S.this.getN() - 1.0) * s + tau) * CE2S.this.alpha / CE2S.this.getN(), CE2S.this.epsilon) * Math.pow(CE2S.this.kappa, CE2S.this.epsilon - 1.0) * (1.0 - CE2S.this.epsilon * Lambda / CE2S.this.getN()), 1.0 / (CE2S.this.epsilon - CE2S.this.alpha * (1.0 - CE2S.this.epsilon)));
            double pd = -CE2S.this.epsilon + 1.0;
            double cs = CE2S.this.sigma * Math.pow(Q, pd) / pd;
            double c = CE2S.this.kappa * Math.pow(B * x, -CE2S.this.alpha);
            double w = cs - CE2S.this.getN() * c * q - CE2S.this.getN() * x;
            return w;
        }
    }

    class twFunctionSolver {
        double beta;
        double optimal;
        UnivariateOptimizer underlying = new BrentOptimizer(1.11E-14, 1.11E-15);
        MultiStartUnivariateOptimizer optimizer;

        twFunctionSolver() {
            this.optimizer = new MultiStartUnivariateOptimizer(this.underlying, 5, CE2S.this.g);
        }

        public void compute() {
            this.optimal = this.optimizer.optimize(new MaxEval(10000), new UnivariateObjectiveFunction(new twFunction(this.beta)), GoalType.MAXIMIZE, new SearchInterval(0.0, 1.0)).getPoint();
        }
    }
}

